/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class Algo {
    private static Logger log = Logger.getLogger(Algo.class);
    private long idSlotToken;
    private long idAlgo;
    private CK_MECHANISM_INFO info;

    public Algo(PKCS11 pKCS11, long l, long l2) throws ExceptionObjet {
        this.idSlotToken = l;
        this.idAlgo = l2;
        this.chargeInfo(pKCS11);
    }

    public void chargeInfo(PKCS11 pKCS11) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                this.info = pKCS11.C_GetMechanismInfo(this.idSlotToken, this.idAlgo);
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations de l'algorithme : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(203, "Une erreur est survenue lors de la r\u00e9cuperation des informations de l'algorithme");
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(203, "La librairie est nulle");
        }
    }

    public String getLibelle() {
        return TraitementsUtil.getNomAlgo(this.idAlgo).replaceAll("_", " ").replaceAll("CKM", "").trim();
    }

    public long getIdAlgo() {
        return this.idAlgo;
    }

    public long getIdSlotToken() {
        return this.idSlotToken;
    }

    public long getTailleMinCle() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMinKeySize;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, la taille minimale de la cl\u00e9 est indisponible");
        throw new ExceptionObjet(203, "La taille minimale de la cl\u00e9 est indisponible");
    }

    public long getTailleMaxCle() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMaxKeySize;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, la taille maximale de la cl\u00e9 est indisponible");
        throw new ExceptionObjet(203, "La taille maximale de la cl\u00e9 est indisponible");
    }

    public boolean isHardware() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 1L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isChiffrement() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x100L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isDechiffrement() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x200L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isRealiseCondensat() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x400L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isRealiseSignature() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x800L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isRecupereSignature() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x1000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isVerificationSignature() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x2000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isVerificationParRecuperation() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x4000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isGenereCleSecrete() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x8000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isGenerePaireCles() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x10000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isChiffreCle() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x20000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isDechiffreCle() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x40000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public boolean isDeriveCle() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x80000L) != 0L;
        }
        log.error((Object)"Les informations de l'algorithme sont nulles, l'information sur l'algorithme est indisponible");
        throw new ExceptionObjet(203, "Linformation sur l'algorithme est indisponible");
    }

    public String toString() {
        return this.getLibelle();
    }
}

